(* ByuTypes.isl *)
(*
Copyright (c) 1994, 1995 Xerox Corporation.  All Rights Reserved.
"Use, reproduction and preparation of derivative works of this
software is permitted, but only for non-comercial research purposes.
Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.
This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES."
*)
(* Doug Terry, June 28, 1994 11:27 am PDT *)
(* Last edited by Mike Spreitzer August 15, 1995 11:15 am PDT *)
(* $Id: ByuTypes.isl,v 1.21 1995/08/15 18:15:25 spreitze Exp $ *)

(* 
   Type declarations common to at least two of:
   ByuCS.isl, ByuSS.isl, ByuDB.h. 
 *)

INTERFACE ByuTypes;

TYPE String = ilu.CString;


(**************** Write ID's and such ****************)

TYPE Stamp = LONG CARDINAL;
(* Monotonically increasing timestamp; assigned by a server
   to identify a Write injected at that server. *)

TYPE CStamp = CARDINAL;
(* Commit sequence number; identifies the ordinal position of a Write
   in the commit sequence. *)

CONSTANT notCommitted: CARDINAL = 0xFFFFFFFF;
(* Special value for use when a CStamp must be associated with
   a tentative Write. *)

TYPE ServerID = SHORT SEQUENCE OF Stamp;

TYPE WriteID = RECORD  (* unique id for a Write *)
    widServer: ServerID,
    widStamp: Stamp
    END;

TYPE Vector = SHORT SEQUENCE OF VectorEntry;  (* version vector *)
TYPE VectorEntry = RECORD
    veServer: ServerID,
    veLastSeen: Stamp
    END;

TYPE VectorPair = RECORD  (* a pair of version vectors *)
    committed: Vector,
    tentative: Vector
    END;

TYPE StateSummmary = RECORD
    ssCmtd: CStamp,
    ssLast: Vector
    END;


(**************** Relations ****************)

TYPE Relation = RECORD
    relSign: Signature,
    relTups: TupleSet
    END;
TYPE Signature = SHORT SEQUENCE OF SigField;
TYPE SigField = RECORD
    sfName: String,
    sfType: DataType
    END;
TYPE DataType = ENUMERATION 
    BoolType,
    IntType,
    CardType,
    RealType,
    StringType,
    BytesType 
    END;
TYPE TupleSet = SHORT SEQUENCE OF Tuple;
TYPE Tuple = SHORT SEQUENCE OF Datum;
TYPE Datum = DataType UNION
    dtBool: BOOLEAN = BoolType END,
    dtInt: INTEGER = IntType END,
    dtCard: CARDINAL = CardType END,
    dtReal: BoxedReal = RealType END,
    dtString: String = StringType END,
    dtBytes: BoxedBytes = BytesType END
    END;
(* We box some types so there are no wasted words in a Datum in memory. *)

TYPE BoxedReal = OPTIONAL RealBox;
(* Not really optional *)

TYPE RealBox = RECORD x: REAL END;
(* Work around former ILU C stub bug; remove when convenient. *)

TYPE BoxedBytes = OPTIONAL Bytes;
(* Not really optional *)

TYPE Bytes = SEQUENCE OF BYTE;

TYPE ServerSet = SHORT SEQUENCE OF ServerID;
(* Here because it's part of the database state.
   If (when!) we need to cope with multiple binding mechanisms,
   the database state will need to contain extra binding
   information for each server. *)


(**************** Schemas ****************)
(* needed when creating servers *)

TYPE Schema = RECORD
    schTables: TableSet,
    schIndices: IndexSet
    END;

TYPE TableSet = SHORT SEQUENCE OF TableDesc;
TYPE TableDesc = RECORD
    tdName: String,
    tdSig: Signature
    END;

TYPE IndexSet = SHORT SEQUENCE OF IndexDesc;
TYPE IndexDesc = RECORD
    idCols: IndexColumnSeq,	(* in order of sorting significance *)
    idUnique: BOOLEAN
    END;

TYPE IndexColumnSeq = SHORT SEQUENCE OF IndexColumn;
TYPE IndexColumn = RECORD
    icIdx: CARDINAL,		(* index into signature *)
    icIncreasing: BOOLEAN	(* sort forward or backward? *)
    END;

(**************** Writes ****************)

TYPE Query = RECORD  (* query in the Bayou query language *)
    bqlVersion: CARDINAL,
    bqlQuery: String
    END;

TYPE DependencySet = SHORT SEQUENCE OF Dependency;  (* check on Write *)
TYPE Dependency = RECORD
    depQuery: Query,
    depExpected: Relation
    END;

TYPE NormalUpdateOp = ENUMERATION Insert, Modify, Delete END;
TYPE NormalUpdate = RECORD
    udOp: NormalUpdateOp,
    udTable: String,
    udMods: Relation
    END;

TYPE ServerUpdateOp = ENUMERATION CreateServer, DeleteServer END;
TYPE ServerUpdate = RECORD
    suOp: ServerUpdateOp,
    suId: ServerID
    END;

TYPE Update = UNION NormalUpdate, ServerUpdate END;
TYPE UpdateSet = SHORT SEQUENCE OF Update;  (* performed on Write *)

TYPE MergeProc = RECORD  (* a merge procedure *)
    mpVersion: CARDINAL,
    mpCode: String
    END;

TYPE Write = RECORD
    wrDeps: DependencySet,
    wrUpdates: UpdateSet,
    wrMerge: MergeProc,
    wrUser: Principal,
    wrCerts: CertSet
    END;

TYPE IdedWrite = RECORD
    iwId: WriteID,
    iwWrite: Write
    END;


(**************** Certificates ****************)

TYPE CertSet = SHORT SEQUENCE OF Cert;

TYPE Cert = SignedMessage;

TYPE SignedMessage = RECORD
    smPlain: Bytes,	(* the plaintext being signed; armored *)
    smSig: Bytes,	(* RSA-encrypted MD5 hash of smPlain *)
    smSignerName: String,  (* Name of signer, this is a hint field *)
    smSigner: Bytes	(* serialized public key of signer *)
    END;

TYPE Principal = Bytes;	(* a serialized public key *)


(**************** Authentication ****************)

TYPE AuthChallenge = ByuTypes.Bytes;
(* A fresh byte sequence for the challengee to sign. *)

TYPE AuthResponse = ByuTypes.Bytes;
(* The result of applying MD-5 and then RSA encryption with the
   private key of the challengee to an AuthChallenge. *)


