#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: hash.c,v 3.2.1.1 95/10/11 10:30:40 raiff Exp $";
#endif /*_BLURB_*/







/* hash.c:  get a hash code for a string in the range 1 to size */

#ifdef __cplusplus
extern "C" {
#endif __cplusplus

#include <strings.h>

#ifdef __cplusplus
}
#endif __cplusplus


int HashString(register char *s, unsigned int size)
{
    register unsigned int sum;
    register int n;
    
    /* Sum the string in reverse so that consecutive integers, as strings, do not
       hash to consecutive locations */
    for (sum = 0, n = strlen(s), s += n-1; n--; s--)
        sum = (sum*31) + (*s-31);
    return ((sum % size) + 1);
}
