#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: comm_daemon.c,v 3.2.1.1 95/10/11 10:24:42 raiff Exp $";
#endif /*_BLURB_*/






/*
 *
 *    Implementation of the Venus Communications daemons.
 *
 *    There are two separate daemons:
 *       1. A "probe" daemon, which periodically and on-demand sends probe messages to servers
 *       2. A "vsg" daemon, which is responsible for maintenance of the VSGDB.
 *
 */


#ifdef __cplusplus
extern "C" {
#endif __cplusplus

#include <libc.h>

#ifdef __cplusplus
}
#endif __cplusplus


#include "comm.h"
#include "venusrecov.h"
#include "simulate.h"
#include "venus.private.h"
#include "vproc.h"


/*  *****  Probe Daemon  *****  */

PRIVATE const int ProbeDaemonStackSize = 40960;
PRIVATE	const int T1Interval = 12 * 60;
PRIVATE	const int T2Interval = 4 * 60;
PRIVATE	const int ProbeInterval	= T2Interval;	    /* min(T1Interval, T2Interval) */

PRIVATE char probe_sync;

void PROD_Init() {
    (void)new vproc("ProbeDaemon", (PROCBODY)&ProbeDaemon,
		     VPT_ProbeDaemon, ProbeDaemonStackSize);    
}

void ProbeDaemon() {
    /* Hack!  Vproc must yield before data members become valid! */
    VprocYield();

    vproc *vp = VprocSelf();
    RegisterDaemon(ProbeInterval, &probe_sync);

    unsigned long LastT1Check = 0;
    unsigned long LastT2Check = 0;

    for (;;) {
	VprocWait(&probe_sync);

	unsigned long curr_time = Vtime();
	int T1Check = 0;
	if (curr_time - LastT1Check >= T1Interval)
	    { LastT1Check = curr_time; T1Check = 1; }
	int T2Check = 0;
	if (curr_time - LastT2Check >= T2Interval)
	    { LastT2Check = curr_time; T2Check = 1; }

	if (!Simulating) 
	    ServerProbe(T1Check, T2Check);

	/* Bump sequence number. */
	vp->seq++;
    }
}


/*  *****  VSG Daemon  *****  */

PRIVATE const int VSGDaemonStackSize = 8192;
PRIVATE const int VSGDaemonInterval = 300;
PRIVATE const int VSGGetDownInterval = 300;

PRIVATE char vsg_sync;

void VSGD_Init() {
    (void)new vproc("VSGDaemon", (PROCBODY) &VSGDaemon,
		     VPT_VSGDaemon, VSGDaemonStackSize);
}

void VSGDaemon() {
    /* Hack!  Vproc must yield before data members become valid! */
    VprocYield();

    vproc *vp = VprocSelf();
    RegisterDaemon(VSGDaemonInterval, &vsg_sync);

    unsigned long curr_time = Vtime();
    unsigned long LastGetDown = curr_time;

    for (;;) {
	VprocWait(&vsg_sync);

	START_TIMING();
	curr_time = Vtime();

	/* Periodically free up cache resources. */
	if (curr_time - LastGetDown >= VSGGetDownInterval) {
	    VSGDB->GetDown();

	    LastGetDown = curr_time;
	}

	END_TIMING();
	LOG(10, ("VSGDaemon: elapsed = %3.1f (%3.1f, %3.1f)\n",
		 elapsed, elapsed_ru_utime, elapsed_ru_stime));

	/* Bump sequence number. */
	vp->seq++;
    }
}


void vsgdb::GetDown() {
    LOG(100, ("vsgdb::GetDown: \n"));

    /* We need to GC unreferenced VSG entries when some reasonable threshold is passed. */
    /* The threshold is assumed to be high enough that it will almost never be hit. */
    /* Therefore, we don't do anything special to prioritize the set of candidate entries. */
#define	VSGThreshold	(CacheFiles >> 4)
    if (VSGDB->htab.count() >= VSGThreshold) {
	vsg_iterator next;
	vsgent *v;
	int readahead = 0;
	while ((VSGDB->htab.count() >= VSGThreshold) && (readahead || (v = next()))) {
	    readahead = 0;

	    if (v->refcnt > 0) continue;

	    vsgent *tv = 0;
	    readahead = ((tv = next()) != 0);

	    LOG(10, ("vsgdb::GetDown: GC'ing %x\n", v->Addr));
	    TRANSACTION(
		delete v;
	    )

	    if (readahead) v = tv;
	}
    }

    /* The number of referenced VSGs is bounded by the number of referenced volumes, which in turn is */
    /* bounded by the number of allocated fsobjs.  However, it is extremely unlikely that this bound will */
    /* ever be hit in the course of normal operation.  It is far more likely that if the bound is reached then */
    /* we have a programming error.  Thus, we panic in such event. */
    if (VSGDB->htab.count() >= CacheFiles)
	Choke("vsgdb::GetDown: vsg entries >= CacheFiles");
}
