#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: advice_daemon.h,v 3.2.1.1 95/10/11 10:24:25 raiff Exp $";
#endif /*_BLURB_*/



/*
 *
 * Specification of the Venus Advice Monitor server.
 *
 */

#ifndef _VENUS_ADVICEDAEMON_H_
#define _VENUS_ADVICEDAEMON_H_

#ifdef __cplusplus
extern "C" {
#endif __cplusplus

#include <stdio.h>
#include <rpc2.h>

#ifdef __cplusplus
}
#endif __cplusplus


#include "vproc.h"

extern int AdviceEnabled;
extern int ASRallowed;

const int DFLT_MAXAMSERVERS = 1;
const int UNSET_MAXAMSERVERS = -1;


class adviceserver : public vproc {
  friend void AdviceInit();

  RPC2_RequestFilter filter;
  RPC2_Handle handle;
  RPC2_PacketBuffer *packet;

  adviceserver();
  adviceserver(adviceserver&);    /* not supported! */
  operator=(adviceserver&);       /* not supported! */
  ~adviceserver();

 public:
  void main(void *);
  void CheckConnections();
};

extern int MaxAMServers;
extern void AdviceInit();

#endif _VENUS_ADVICEDAEMON_H_

