#!/bin/csh -f

#ifndef _BLURB_
#define _BLURB_
#/*
#
#            Coda: an Experimental Distributed File System
#                             Release 3.1
#
#          Copyright (c) 1987-1995 Carnegie Mellon University
#                         All Rights Reserved
#
#Permission  to  use, copy, modify and distribute this software and its
#documentation is hereby granted,  provided  that  both  the  copyright
#notice  and  this  permission  notice  appear  in  all  copies  of the
#software, derivative works or  modified  versions,  and  any  portions
#thereof, and that both notices appear in supporting documentation, and
#that credit is given to Carnegie Mellon University  in  all  documents
#and publicity pertaining to direct or indirect use of this code or its
#derivatives.
#
#CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
#SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
#FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
#DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
#RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
#ANY DERIVATIVE WORK.
#
#Carnegie  Mellon  encourages  users  of  this  software  to return any
#improvements or extensions that  they  make,  and  to  grant  Carnegie
#Mellon the rights to redistribute these changes without encumbrance.
#*/
#
#static char *rcsid = "$Header: bldvldb.sh,v 3.2.1.1 95/10/11 10:17:55 raiff Exp $";
#endif /*_BLURB_*/

cd /vice/vol/remote

# Get the volume lists from the servers

# NOTE: for ftp to work correctly, there needs to be a file .anonr in the
# directory /vice/vol which contains the word "VolumeList"
 
foreach server (`awk '{ print $2 }' /vice/db/hosts`)
    echo ${server}
    cat << EOF | ftp -n ${server}
	user anonymous codaserver@mahler
	get /vice/vol/VolumeList /vice/vol/remote/${server}.list.new
EOF

    if (! -r /vice/vol/remote/${server}.list.new) then
        if (-r /../${server}/vice/vol/VolumeList) then
	    cat /../${server}/vice/vol/VolumeList >/vice/vol/remote/${server}.list.new
	else
	        echo "Trouble getting new list for server $server"
	endif
    endif

    if (-r /vice/vol/remote/${server}.list.new) then
        mv /vice/vol/remote/${server}.list.new /vice/vol/remote/${server}.list
    endif

end

# Make on big list called composite
cd /vice/vol/remote; cat *.list> ../BigVolumeList

# Make a new vldb from the list
/vice/bin/volutil makevldb  /vice/vol/BigVolumeList
