#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: norton.c,v 3.2.2.1 95/10/11 10:10:34 raiff Exp $";
#endif /*_BLURB_*/



#ifdef __cplusplus
extern "C" {
#endif __cplusplus

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
    
#include <lwp.h>
#include <rvm.h>
#include <rds.h>

#ifdef __cplusplus
}
#endif __cplusplus

#include <dir.h>
#include <rvmdir.h>
#include <rvmlib.h>

#include "parser.h"
#include "norton.h"

#define NUMBUFS 20


struct camlib_recoverable_segment *camlibRecoverableSegment;

void usage(char * name) {
    fprintf(stderr, "Usage: %s <log_device> <data_device> <length>\n",
	    name);
}


void LoadRVM(char * log_dev, char * data_dev, rvm_offset_t data_len) {
    rvm_return_t err;
    rvm_options_t * options;
    rvm_perthread_t *rvmptt;
    struct stat buf;

    if (stat(log_dev, &buf)) {
	perror("Reading log device");
	exit(1);
    }

    if (stat(data_dev, &buf)) {
	perror("Reading data device");
	exit(1);
    }
    

    /* Set the per-thread data structure, don't ever free this. */
    rvmptt = (rvm_perthread_t *)malloc(sizeof(rvm_perthread_t));
    rvmptt->tid = NULL;
    rvmptt->list.table = NULL;
    rvmptt->list.count = 0;
    rvmptt->list.size = 0;
    rvmptt->die = NULL;
    RVM_SET_THREAD_DATA(rvmptt);
    assert(RVM_THREAD_DATA != 0);

    options = rvm_malloc_options();
    options->log_dev = log_dev;
    options->flags = 0;
    options->truncate = 0;

    printf("About to call RVM_INIT\n");
    fflush(stdout);
    if ((err = RVM_INIT(options)) != RVM_SUCCESS) {
	fprintf(stderr, "rvm_init failed %s\n", rvm_return(err));
	exit(1);
    }

    printf("About to call rds_load_heap\n");
    fflush(stdout);
    rds_load_heap(data_dev, data_len,
		  (char **)&camlibRecoverableSegment,
		  (int *)&err); 
    if (err != RVM_SUCCESS) {
	fprintf(stderr, "rds_load_heap error %s\n", rvm_return(err));
	exit(1);
    }

    rvm_free_options(options);
}



/* Initialize LWP */
void InitLWP() {
    PROCESS	pid;
    int		ret;
    
    ret = LWP_Init(LWP_VERSION, LWP_NORMAL_PRIORITY, &pid);
    if (ret != LWP_SUCCESS) {
	fprintf(stderr, "LWP_Init failed!\n");
	exit(1);
    }

    /* Initialize IOMGR!  BAH!  LWP_Init should do this! */
    ret = IOMGR_Initialize();
    if (ret != LWP_SUCCESS) {
	fprintf(stderr, "IOMGR_Initialize failed!  Return = %d\n", ret);
	exit(1);
    }
}



int main(int argc, char * argv[]) {
    rvm_return_t 	err;
    struct stat		buf;
    
    RvmType = RAWIO; 	/* initialize rvmlib code */

    if (argc != 4) {
	usage(argv[0]);
	exit(1);
    }

    /* Make sure there isn't a server already running */
    if (stat("/vice/srv/pid", &buf) == 0) {
	fprintf(stderr, "ERROR: A file server is already running!\n");
	fprintf(stderr, "       Shut it down before running 'norton'\n");
	exit(1);
    }
    
    InitLWP();
    LoadRVM(argv[1], argv[2], RVM_MK_OFFSET(0, atoi(argv[3])));

    /* Initialize the dir package buffer system */
    DInit(NUMBUFS);

    /* Initialize the RVM directory hash table */
    DirHtbInit();
    
    InitParsing();
    parse_commands();

    err = rvm_terminate();
    printf("rvm_terminate returns %s\n", rvm_return(err));
}
