#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: joingroup.c,v 3.2.2.1 95/10/11 10:06:19 raiff Exp $";
#endif /*_BLURB_*/





/*
 * joingroup() user library routine
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>

#define NULL 0

int joingroup(groupaddr, key1, key2, loopback, interface)
	struct in_addr groupaddr;
	unsigned long  key1, key2;	/* unused */
	unsigned int   loopback;	/* Boolean */
	char *         interface;	/* e.g. "de0", or NULL */

	/* returns a membership socket number if successful. */
	/* returns -1 if unsuccessful, with reason in errno. */

	/* MISFEATURE: should use interface's IP address, not its name. */
{
#ifdef GET_KLEMETS_TO_FIX_THIS
	int s;
	struct ip_mreq imr;
	struct ifreq ifr;

	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		return(-1);

	if (interface != NULL) {
		strcpy(ifr.ifr_name, interface);
		if(ioctl(s, SIOCGIFADDR, &ifreq) < 0) {
			close(s);
			return -1;
		}
		imr.imr_interface = ((struct sockaddr_in *) &ifreq.ifr_addr)->sin_addr;
	}
	else
		imr.imr_interface = htonl(INADDR_ANY);
	imr.imr_multiaddr = groupaddr;
		
	if(setsockopt(s, IPPROTO_IP, IP_ADD_MEMBERSHIP,
		      &imr, sizeof(struct ip_mreq) ) < 0) {
		close(s);
		return -1;
	}
	if(setsockopt(s, IPPROTO_IP, IP_MULTICAST_LOOP, &loopback,
		      sizeof(loopback) ) < 0) {
		close(s);
		return -1;
	}
	return s;
#endif GET_KLEMETS_TO_FIX_THIS
}
