#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: creategroup.c,v 3.2.2.1 95/10/11 10:06:15 raiff Exp $";
#endif /*_BLURB_*/





/*
 * creategroup() user library routine
 */

#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/igmp.h>
#include <netinet/igmp_user.h>

#define NULL 0

extern int errno;

int creategroup(groupaddr, key1, key2, private, loopback, interface)
	struct in_addr *groupaddr;
	unsigned long  *key1, *key2;
	unsigned int   private;		/* Boolean */
	unsigned int   loopback;	/* Boolean */
	char *         interface;	/* e.g. "de0", or NULL */

	/* returns a membership socket number if successful. */
	/* returns -1 if unsuccessful, with reason in errno. */

	/* MISFEATURE: should use interface's IP address, not its name. */
{
#ifdef GET_KLEMETS_TO_FIX_THIS
	int s;
	struct igmpreqargs req;

	req.type = IGMP_CREATE_GROUP_REQUEST;
	req.code = (u_char)private;
	req.groupaddr.s_addr = 0;
	req.key1 = 0;
	req.key2 = 0;
	req.loopback = (u_char)loopback;

        if ((*interface >= '0') && (*interface <= '9'))
	    req.ifr_name[0] = '\0';
	else {
		strncpy(req.ifr_name, interface, IFNAMSIZ);
		req.ifr_name[IFNAMSIZ-1] = '\0';
	}

	if ((s = socket(PF_INET, SOCK_DGRAM, IPPROTO_IGMP)) < 0)
		return(-1);

	if (ioctl(s, SIOCIGMPREQ, &req) >= 0) switch (req.code) {

		case IGMP_REQUEST_GRANTED:
						groupaddr->s_addr =
						req.groupaddr.s_addr;
						*key1 = req.key1;
						*key2 = req.key2;
						return(s);

		case IGMP_NO_RESOURCES:		errno = ENOSPC;		break;
		case IGMP_INVALID_CODE:		errno = EINVAL;		break;
		case IGMP_INVALID_GROUP_ADDRESS:errno = EADDRNOTAVAIL;	break;
		case IGMP_INVALID_ACCESS_KEY:	errno = EACCES;		break;
		case IGMP_NO_INTERNAL_RESOURCES:errno = ENOBUFS;	break;
		case IGMP_NO_RESPONSE:		errno = ETIMEDOUT;	break;
		case IGMP_INVALID_TYPE:		errno = EINVAL;		break;
		case IGMP_NO_PERMISSION:	errno = EPERM;		break;
		case IGMP_NO_INTERFACE:		errno = EINVAL;		break;
		case IGMP_SOCKET_IN_USE:	errno = EISCONN;	break;
		case IGMP_NO_SOCKET:		errno = ENOTSOCK;	break;
		case IGMP_NOT_A_MEMBER:		errno = ENOTCONN;	break;
		case IGMP_ALREADY_A_MEMBER:	errno = EISCONN;	break;
		default:			errno = EINVAL;		break;

	}
	close(s);
	return(-1);
#endif GET_KLEMETS_TO_FIX_THIS
}
