#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: dtcreg.h,v 3.2.2.1 95/10/11 10:04:42 raiff Exp $";
#endif /*_BLURB_*/

/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * This code was written for the Coda file system at Carnegie Mellon University.
 * Contributers include David Steere, James Kistler, and M. Satyanarayanan.
 */

/* 
 * HISTORY
 * $Log:	dtcreg.h,v $
 * Revision 3.2.2.1  95/10/11  10:04:42  raiff
 * Branch for release beta-11Oct1995_34901
 * 
 * Revision 3.2  95/10/09  19:25:12  satya
 * Reblurbed with new CMU and IBM notices for SOSP-15 CD-ROM
 * 
 * Revision 3.1  95/06/08  16:03:32  satya
 * *** empty log message ***
 * 
 * Revision 2.1.7.1  95/05/11  11:14:29  raiff
 * Branch for release beta-11May1995_36561
 * 
 * Revision 2.1  94/07/21  16:25:37  satya
 * Conversion to C++ 3.0; start of Coda Release 2.0
 * 
 * Revision 1.2  92/10/27  17:58:52  lily
 * merge kernel/latest and alpha/src/cfs
 * 
 * Revision 2.2  90/07/05  11:27:38  mrt
 * 	Created for the Coda File System.
 * 	[90/05/23            dcs]
 * 
 * Revision 1.1  90/05/31  17:04:40  dcs
 * Initial revision
 * 
 * 
 */

#ifndef _DTCREG_H_
#define _DTCREG_H_

/* location of major registers on Data Translation 2806 board */

#define	Timer0	(caddr_t) 0xF0000370
#define Timer1	(caddr_t) 0xF0000770
#define Timer2	(caddr_t) 0xF0000B70
#define ModeReg (caddr_t) 0xF0000F70
#define FPLA	(caddr_t) 0xF0001770

/*
 * Support for the IOCTLs for DTC .
 */
struct dtcclk {
	long dtc_low, dtc_high;
	};

#define DTCSCLK	_IO(d,1)		/* set device bounds */
#define DTCBCLK	_IOR(d,3, struct dtcclk) /* return bound settings */
#define DTCRCLK	_IOR(d,2, struct dtcclk) /* return bound settings */
#define DTCRLS  _IOR(d,4, struct timeval)/* return base time value */ 
#define DTCCTL  _IO(d,5)

/* debugging values */

#define DTCDEBUG 0x1			/* turn on debugging in dtc.c */

#endif _DTCREG_H_
