#ifndef _BLURB_
#define _BLURB_
#ifdef undef
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: dtcdiv.s,v 3.2.2.1 95/10/11 10:04:33 raiff Exp $";
#endif undef
#endif /*_BLURB_*/

/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * This code was written for the Coda file system at Carnegie Mellon University.
 * Contributers include David Steere, James Kistler, and M. Satyanarayanan.
 */

/* 
 * HISTORY
 * $Log:	dtcdiv.s,v $
Revision 3.2.2.1  95/10/11  10:04:33  raiff
Branch for release beta-11Oct1995_34901

Revision 3.2  95/10/09  19:25:11  satya
Reblurbed with new CMU and IBM notices for SOSP-15 CD-ROM

Revision 3.1  95/06/08  16:03:32  satya
*** empty log message ***

Revision 2.1.7.1  95/05/11  11:14:27  raiff
Branch for release beta-11May1995_36561

Revision 2.1  94/07/21  16:25:36  satya
Conversion to C++ 3.0; start of Coda Release 2.0

Revision 1.2  92/10/27  17:58:48  lily
merge kernel/latest and alpha/src/cfs

 * Revision 2.2  90/07/05  11:27:34  mrt
 * 	Created for the Coda File System.
 * 	[90/05/23            dcs]
 * 
 */

#include <dtc.h>
#if	NDTC > 0

 #	Divide of dtcsec//dtcusec by 2000000
 #		-- We have a 48 bit counter that holds the number of 
 #		   1/2 microsecond ticks that have elapsed since the clock
 #		   was started. This routine converts this number into
 #		   seconds and microseconds

 #				r2//mq = dividend
 #				r3 = divisor
 #				r15= link
 #			

.set mq      ,       r10                # multiplier quotient system control reg
 
	.globl	.oVncs
	.set	.oVncs,0

	.globl  _dtcsec
	.globl  _dtcusec
	.globl	_twomeg
	.data
L00_DATA:
	.set	_twomeg,L00_DATA+0x00000000
	.long	2000000

	.text
	.globl	_.dtcdiv
_.dtcdiv:
	mr	r0,r4
	load    r2,_dtcsec
	load	r4,_dtcusec
	mts	%mq,r4
	load	r3,_twomeg

here: 				# 32 divide steps:
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3		# 8

        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3		# 16

        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3		# 24

        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3
        d       r2,r3		# 32
 
	bc0x	1f		# if carry-0, no correction needed
	mfs	%mq,r4		# (retrieve the quotient)
	a	r2,r3		# correction: complete the final restore

1:	
	#the remainder is actually the number of 1/2 usecs, so 
	sri	r2,1
        #return to the calling routine
        store	r4,_dtcsec,r3
	store	r2,_dtcusec,r3
	brx	r15
	mr	r4,r0


	.globl	_dtcdiv
	.data
_dtcdiv:

#endif	/* NDTC */
