#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: cnode.h,v 3.2.2.1 95/10/11 10:04:16 raiff Exp $";
#endif /*_BLURB_*/

/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * This code was written for the Coda file system at Carnegie Mellon University.
 * Contributers include David Steere, James Kistler, and M. Satyanarayanan.
 */

/* 
 * HISTORY
 * $Log:	cnode.h,v $
 * Revision 3.2.2.1  95/10/11  10:04:16  raiff
 * Branch for release beta-11Oct1995_34901
 * 
 * Revision 3.2  95/10/09  19:25:09  satya
 * Reblurbed with new CMU and IBM notices for SOSP-15 CD-ROM
 * 
 * Revision 3.1  95/06/08  16:03:30  satya
 * *** empty log message ***
 * 
 * Revision 3.1.4.1  95/05/11  11:14:21  raiff
 * Branch for release beta-11May1995_36561
 * 
 * Revision 3.1  95/03/04  19:08:23  bnoble
 * Bump to major revision 3 to prepare for NetBSD port
 * 
 * Revision 2.2  1994/12/06  13:39:18  dcs
 * Add a flag value to indicate a cnode was orphaned, e.g. the venus
 * that created it has exited. This will allow one to restart venus
 * even though some process may be cd'd into /coda.
 *
 * Revision 2.1  94/07/21  16:25:33  satya
 * Conversion to C++ 3.0; start of Coda Release 2.0
 * 
 * Revision 1.2.7.1  94/06/16  11:26:02  raiff
 * Branch for release beta-16Jun1994_39118
 * 
 * Revision 1.2  92/10/27  17:58:41  lily
 * merge kernel/latest and alpha/src/cfs
 * 
 * Revision 2.3  92/09/30  14:16:53  mja
 * 	Picked up fixed #ifdef KERNEL. Also...
 * 
 * 	Substituted rvb's history blurb so that we agree with Mach 2.5 sources.
 * 	[91/02/09            jjk]
 * 
 * 	Added contributors blurb.
 * 	[90/12/13            jjk]
 * 
 * Revision 2.2  90/07/05  11:27:24  mrt
 * 	Created for the Coda File System.
 * 	[90/05/23            dcs]
 * 
 * Revision 1.4  90/05/31  17:02:16  dcs
 * Prepare for merge with facilities kernel.
 * 
 * 
 * 
 */

#ifndef	_CNODE_H_
#define	_CNODE_H_

#include <sys/types.h>
#ifdef	KERNEL
#include <vfs/vnode.h>
#ifndef	VICEFID_DEFINED
#define	VICEFID_DEFINED	1
typedef u_long VolumeId;
typedef u_long VnodeId;
typedef u_long Unique;
typedef struct ViceFid {
    VolumeId Volume;
    VnodeId Vnode;
    Unique Unique;
} ViceFid;
#endif	not VICEFID_DEFINED
#else	KERNEL
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#endif	KERNEL

struct cnode {
    struct vnode    c_vnode;
    u_short	    c_flags;	/* flags (see below) */
    ViceFid	    c_fid;	/* file handle */
#ifdef	KERNEL
    struct vnode    *c_ovp;	/* open vnode pointer */
    u_short	    c_ocount;	/* count of openers */
    u_short         c_owrite;   /* count of open for write */
    struct vattr    c_vattr;    /* attributes */
    char            *c_symlink; /* pointer to symbolic link */
    u_short         c_symlen;   /* length of symbolic link */
#endif	KERNEL
    dev_t	    c_device;	/* associated vnode device */
    ino_t	    c_inode;	/* associated vnode inode */
};

/* flags */
#define C_VATTR       0x1         /* Validity of vattr in the cnode */
#define VALID_VATTR(cp)          ((cp->c_flags) & C_VATTR)

#define C_SYMLINK     0x2         /* Validity of symlink pointer in the cnode */
#define VALID_SYMLINK(cp)        ((cp->c_flags) & C_SYMLINK)

#ifdef KERNEL
#define C_DYING	      0x4	  /* Set for outstanding cnodes from last venus (which died) */
#define IS_DYING(cp)		 ((cp->c_flags) & C_DYING)
#endif KERNEL
/*
 * Macro operations on the cnode
 */
/* Convert between vnode and cnode */
#define	VTOC(vp)	((struct cnode *)(vp))
#define	CTOV(cp)	((struct vnode *)(cp))

#ifdef	KERNEL
#define CN_INIT(CP) {\
    bzero((CP), (int)sizeof(struct cnode));\
}
#else	KERNEL
#define CN_INIT(CP, FID, DEV, INO) {\
    bzero((CP), (int)sizeof(struct cnode));\
    VN_INIT(CTOV((CP)), 0, 0, 0);\
    (CP)->c_fid = FID;\
    (CP)->c_device = DEV;\
    (CP)->c_inode = INO;\
}
#endif	KERNEL

#define	CNODE_NEXT(cp)	(VTOC(CTOV(cp)->v_next))

#endif	not _CNODE_H_

