#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: cfsnc_resize.c,v 3.2.2.1 95/10/11 10:03:53 raiff Exp $";
#endif /*_BLURB_*/

/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * This code was written for the Coda file system at Carnegie Mellon University.
 * Contributers include David Steere, James Kistler, and M. Satyanarayanan.
 */

/*
 * HISTORY
 * $Log:	cfsnc_resize.c,v $
 * Revision 3.2.2.1  95/10/11  10:03:53  raiff
 * Branch for release beta-11Oct1995_34901
 * 
 * Revision 3.2  95/10/09  19:25:07  satya
 * Reblurbed with new CMU and IBM notices for SOSP-15 CD-ROM
 * 
 * Revision 3.1  95/06/08  16:03:29  satya
 * *** empty log message ***
 * 
 * Revision 3.1.4.1  95/05/11  11:14:15  raiff
 * Branch for release beta-11May1995_36561
 * 
 * Revision 3.1  95/03/04  19:08:11  bnoble
 * Bump to major revision 3 to prepare for NetBSD port
 * 
 * Revision 2.1  1994/07/21  16:25:30  satya
 * Conversion to C++ 3.0; start of Coda Release 2.0
 *
 * Revision 1.2  92/10/27  17:58:36  lily
 * merge kernel/latest and alpha/src/cfs
 * 
 * Revision 2.2  90/07/05  11:27:11  mrt
 * 	Created for Coda file system
 * 	[90/07/05  10:15:39  mrt]
 * 
 * Revision 1.2  90/03/19  16:35:26  dcs
 * Changed Revision Log.
 * 
 */

/*
 * This file will send an ioctl to the cfs device driver (vcioctl in cfs_subr.c)
 * which will cause the cfs name cache to change it's size.
 */

#include <sys/ioctl.h>
#include <cfs/cfsio.h>

main(argc, argv)
     int argc;
     char *argv[];
{
  struct cfs_resize data;

  int fd, err;

  if (argc < 3) {
    printf("Usage: cfsnc_resize <newheapsize> <newhashsize>\n");
    exit(-1);
  }

  data.heapsize = atoi(argv[1]);
  data.hashsize = atoi(argv[2]);

  if ((data.heapsize % 2) || (data.hashsize %2)) {
    printf("The sizes must be multiples of 2\n");
    exit(-1);
  }

  fd = open("/dev/cfs1",0,0);
  if (fd < 0) {
    perror("Open /dev/cfs1");
    exit(-1);
  }

  err = ioctl(fd, CFSRESIZE, &data);
  if (err < 0) {
    perror("Ioctl /dev/cfs1");
    exit(-1);
  }

  close(fd);
}




