#ifndef _BLURB_
#define _BLURB_
/*

            Coda: an Experimental Distributed File System
                             Release 3.1

          Copyright (c) 1987-1995 Carnegie Mellon University
                         All Rights Reserved

Permission  to  use, copy, modify and distribute this software and its
documentation is hereby granted,  provided  that  both  the  copyright
notice  and  this  permission  notice  appear  in  all  copies  of the
software, derivative works or  modified  versions,  and  any  portions
thereof, and that both notices appear in supporting documentation, and
that credit is given to Carnegie Mellon University  in  all  documents
and publicity pertaining to direct or indirect use of this code or its
derivatives.

CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
ANY DERIVATIVE WORK.

Carnegie  Mellon  encourages  users  of  this  software  to return any
improvements or extensions that  they  make,  and  to  grant  Carnegie
Mellon the rights to redistribute these changes without encumbrance.
*/

static char *rcsid = "$Header: cfsio.h,v 3.3.2.1 95/10/11 10:03:44 raiff Exp $";
#endif /*_BLURB_*/

/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * This code was written for the Coda file system at Carnegie Mellon University.
 * Contributers include David Steere, James Kistler, and M. Satyanarayanan.
 */

/* 
 * HISTORY
 * $Log:	cfsio.h,v $
 * Revision 3.3.2.1  95/10/11  10:03:44  raiff
 * Branch for release beta-11Oct1995_34901
 * 
 * Revision 3.3  95/10/09  19:25:04  satya
 * Reblurbed with new CMU and IBM notices for SOSP-15 CD-ROM
 * 
 * Revision 3.2  95/10/06  16:37:22  dcs
 * Added new ioctls for debugging purposes.
 * 
 * Revision 3.1  95/06/08  16:03:27  satya
 * *** empty log message ***
 * 
 * Revision 3.1.4.1  95/05/11  11:14:06  raiff
 * Branch for release beta-11May1995_36561
 * 
 * Revision 3.1  95/03/04  19:08:20  bnoble
 * Bump to major revision 3 to prepare for NetBSD port
 * 
 * Revision 2.1  1994/07/21  16:25:25  satya
 * Conversion to C++ 3.0; start of Coda Release 2.0
 *
 * Revision 1.3  94/06/14  16:53:47  dcs
 * Added support for ODY-like mounting in the kernel (SETS)
 * 
 * Revision 1.3  94/06/14  16:48:03  dcs
 * Added support for ODY-like mounting in the kernel (SETS)
 * 
 * Revision 1.2  92/10/27  17:58:28  lily
 * merge kernel/latest and alpha/src/cfs
 * 
 * Revision 1.1  92/04/03  17:35:34  satya
 * Initial revision
 * 
 * Revision 1.5  91/02/09  12:53:26  jjk
 * Substituted rvb's history blurb so that we agree with Mach 2.5 sources.
 * 
 * Revision 2.2.1.1  91/01/06  22:08:22  rvb
 * 	Created for the Coda File System.
 * 	[90/05/23            dcs]
 * 
 * Revision 1.3  90/07/19  10:23:05  dcs
 * Added ; to cfs_resize definition for port to 386.
 * 
 * Revision 1.2  90/05/31  17:02:09  dcs
 * Prepare for merge with facilities kernel.
 * 
 * 
 * 
 */

#ifndef _CFSIO_H_
#define _CFSIO_H_

/* Define ioctl commands for vcioctl, /dev/cfs */

#ifdef __STDC__
#define CFSRESIZE    _IOW('c', 1, struct cfs_resize )  /* Resize CFS NameCache */
#define CFSSTATS      _IO('c', 2)                      /* Collect stats */
#define CFSPRINT      _IO('c', 3)                      /* Print Cache */
#define CFSTEST       _IO('c', 4)                      /* Print Cache */
#define ODYBIND	     _IOW('c', 5, struct ody_bind )    /* Bind a name to a FS */
#define ODYPROD	     _IOW('c', 6, char * )   	       /* Bind a name to a FS */
#define ODYREQ	     _IOW('c', 7, int)		       /* Bind a name to a FS */
#else /* sys/ioctl.h puts the quotes on */
#define CFSRESIZE    _IOW(c, 1, struct cfs_resize )  /* Resize CFS NameCache */
#define CFSSTATS      _IO(c, 2)                      /* Collect stats */
#define CFSPRINT      _IO(c, 3)                      /* Print Cache */
#define CFSTEST       _IO(c, 4)                      /* Print Cache */
#define ODYBIND	     _IOW(c, 5, struct ody_bind )    /* Bind a name to a FS */
#define ODYPROD	     _IOW(c, 6, char * )             /* Bind a name to a FS */
#define ODYREQ	     _IOW(c, 7, int)                 /* Bind a name to a FS */
#endif __STDC__


struct cfs_resize { int hashsize, heapsize; };
struct ody_bind { int size; char *name; };

#endif !_CFSIO_H_
