#!/bin/csh -f -b
#

set prog=install.sh
set CODAETC=/usr/coda/etc
set TCLBIN=/usr/coda/etc
set TCLDIR=/usr/coda/tcl
set TCLLIB={$TCLDIR}/lib
set TCLFONT={$TCLDIR}/fonts
set SCRIPTS=discomiss,hoardlist,misslist,reconnection,user_initiated

if ($#argv != 1) goto usage

switch ("$argv[1]")
    case "mre":
        set BINDIR=/coda/usr/mre/src/OBJS/@sys/advice
	set SCRIPTDIR=/coda/usr/mre/src/advice
        breaksw
    case "alpha":
        set BINDIR=/coda/project/coda/alpha/bin
	set SCRIPTDIR=/coda/project/coda/alpha/bin
        breaksw
    default:
        echo "${prog}: unknown switch ($argv[1])"
        goto usage
        breaksw
endsw


# Assume that CODAETC AND TCLBIN both exist!

# Copy advice server into the local Coda binary area.
copy $BINDIR/advice_srv $CODAETC
copy $SCRIPTDIR/{$SCRIPTS} $CODAETC
chmod 0755 $CODAETC/{$SCRIPTS}

# Copy tcl files into the local tcl library area.
copy /usr/misc/.tcl/bin/wish $CODAETC
mkdir $TCLDIR
mkdir $TCLLIB
mkdir {$TCLLIB}/tcl
copy /usr/misc/.tcl/lib/tcl/*.tcl $TCLLIB/tcl
copy /usr/misc/.tcl/lib/tcl/tclIndex $TCLLIB/tcl
mkdir {$TCLLIB}/tk
copy /usr/misc/.tcl/lib/tk/*.tcl $TCLLIB/tk
copy /usr/misc/.tcl/lib/tk/tclIndex $TCLLIB/tk

# Copy the necessary font file into the tcl
mkdir $TCLFONT
copy /usr/misc/.X11/lib/fonts/75dpi/courR12.* $TCLFONT
echo "You must add $TCLFONT to your XFILESEARCHPATH environment variable."

# Assume the user has X11 and a window manager hoarded correctly!




# Exit normally
exit 0

# Exit with Usage statement
usage:
echo "Usage: ${prog} [mre] [alpha]"
exit 0

